// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use glam::Vec2;
use serde::{Serialize, Deserialize};

use super::colour::ColourAlpha;

use crate::utils::maths::{Rect, RectCorners};

#[derive(Clone, Serialize, Deserialize)]
pub struct SpecialArea {
	p0: Vec2,
	p1: Vec2,
	p2: Vec2,
	colour: ColourAlpha,
}

impl SpecialArea {
	#[cfg(feature = "client")]
	pub fn new(p0: Vec2, p1: Vec2, p2: Vec2, colour: ColourAlpha) -> SpecialArea {
		SpecialArea { p0, p1, p2, colour }
	}

	pub fn rect(rect: RectCorners, colour: ColourAlpha) -> [SpecialArea; 2] {
		let (p0, p2) = (rect.get_p0(), rect.get_p1());
		[
			SpecialArea { p0, p1: Vec2::new(p2.x, p0.y), p2, colour },
			SpecialArea { p0, p1: Vec2::new(p0.x, p2.y), p2, colour },
		]
	}

	#[cfg(feature = "client")]
	pub fn get_points(&self) -> (Vec2, Vec2, Vec2) {
		(self.p0, self.p1, self.p2)
	}

	pub fn get_colour(&self) -> ColourAlpha {
		self.colour
	}
}
