// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use glam::Vec2;

use super::{PlayerId, TeamId};

pub struct Forcefield {
	pub player_id: PlayerId,
	pub team_id: Option<TeamId>,
	pub pos: Vec2,
	pub strength: f32,
}

impl Forcefield {
	pub const RADIUS: f32 = 4.0;

	pub fn strength(pos_a: Vec2, pos_b: Vec2) -> Option<f32> {
		let dist2 = pos_a.distance_squared(pos_b);
		(dist2 < Forcefield::RADIUS * Forcefield::RADIUS).then(|| {
			let t = dist2.sqrt() / Forcefield::RADIUS;
			(256.0 / 27.0) * t * t * t * (1.0 - t)
		})
	}
}
