// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use serde::{Serialize, Deserialize};
use glam::Vec2;

use super::player::config::PlayerConfig;

#[derive(Clone, Serialize, Deserialize)]
#[serde(rename = "World", deny_unknown_fields)]
pub struct WorldConfig {
	pub size: Vec2,
	#[serde(default)] pub friendly_fire: bool,
	#[serde(default)] pub default_player: PlayerConfig,
	#[serde(default = "powerup_time_default")] pub powerup_time: f32,
}

fn powerup_time_default() -> f32 { 10.0 * 60.0 }

pub const MAX_SIZE: f32 = 65536.0;
