// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use serde::{Serialize, Deserialize};
use glam::Vec2;

use crate::utils::maths::Circle;

pub const RADIUS: f32 = 1.0;

#[derive(Clone, Serialize, Deserialize)]
pub struct Checkpoint {
	pos: Vec2,
}

impl Checkpoint {
	#[cfg(feature = "client")]
	pub fn new(pos: Vec2) -> Checkpoint {
		Checkpoint { pos }
	}
}

impl Circle for Checkpoint {
	fn get_pos(&self) -> Vec2 { self.pos }
	fn get_radius(&self) -> f32 { RADIUS }
}
