// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::ops::Deref;

pub fn create(s: &mut String, list: &[impl Deref<Target = str>], word: &str) {
	for (i, item) in list.iter().enumerate() {
		if i == list.len() - 1 && i > 0 {
			s.push(' ');
			*s += word;
			s.push(' ');
		} else if i > 0 {
			*s += ", ";
		}

		*s += item;
	}
}

#[cfg(test)]
mod tests {
	fn create(list: &[&str], word: &str) -> String {
		let mut s = String::new();
		super::create(&mut s, list, word);
		s
	}

	#[test]
	fn empty() {
		assert_eq!(create(&[], "and"), "");
		assert_eq!(create(&[], ""), "");
	}

	#[test]
	fn one() {
		assert_eq!(create(&["1"], "and"), "1");
		assert_eq!(create(&["asdf"], ""), "asdf");
	}

	#[test]
	fn two() {
		assert_eq!(create(&["1", "2"], "and"), "1 and 2");
		assert_eq!(create(&["3", "4"], "or"), "3 or 4");
		assert_eq!(create(&["5", "6"], "X"), "5 X 6");
	}

	#[test]
	fn more() {
		assert_eq!(create(&["1", "2", "3"], "and"), "1, 2 and 3");
		assert_eq!(create(&["1", "2", "3", "4"], "or"), "1, 2, 3 or 4");
	}
}
