// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use ron::{Options, extensions::Extensions, error::SpannedError};
use serde::Deserialize;

pub fn deserialise<'a, T: Deserialize<'a>>(data: &'a [u8]) -> Result<T, SpannedError>  {
	Options::default()
		.with_default_extension(Extensions::UNWRAP_NEWTYPES)
		.with_default_extension(Extensions::IMPLICIT_SOME)
		.from_bytes(data)
}
