// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use rand::RngCore;

const MAX: u32 = 1 << 24;

#[inline]
fn to_float(x: u32) -> f32 {
	(x % MAX) as f32 / MAX as f32
}

pub trait Float: RngCore {
	/** Returns a random f32 in [0, 1). */
	fn next_f32(&mut self) -> f32 {
		to_float(self.next_u32())
	}
}

impl<T> Float for T where T: RngCore {}

#[cfg(test)]
mod tests {
	use super::*;

	#[test]
	fn never_one() {
		for i in MAX - 30..=MAX + 30 {
			assert!(to_float(i) < 1.0);
		}
	}
}
