// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
/**
 * Enum to be used when you want to encode two optional values with the
 * condition that at least one must exist. In other words, equivalent to
 * (Option<A>, Option<B>) without the (None, None) case.
 */
#[derive(Debug)]
pub enum Or<A, B> {
	Both(A, B),
	A(A),
	B(B),
}

impl<A, B> Or<A, B> {
	pub fn map_b<C>(self, f: impl FnOnce(B) -> C) -> Or<A, C> {
		match self {
			Or::Both(a, b) => Or::Both(a, f(b)),
			Or::A(a) => Or::A(a),
			Or::B(b) => Or::B(f(b)),
		}
	}
}
