// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::ops::DerefMut;

use glium::buffer::{Buffer, WriteMapping};

pub struct GliumWriter<'a, T: Copy> {
	buf: WriteMapping<'a, [T]>,
	i: usize,
}

// Lots of generics here!
impl<'a, T: Copy + 'a> GliumWriter<'a, T> {
	pub fn new(buf: &'a mut impl DerefMut<Target = Buffer<[T]>>) -> GliumWriter<'a, T> {
		GliumWriter { buf: buf.map_write(), i: 0 }
	}

	pub fn get_index(&self) -> usize { self.i }

	pub fn push(&mut self, x: T) {
		self.buf.set(self.i, x);
		self.i += 1;
	}
}
