// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use glium::{VertexBuffer, IndexBuffer, Display, Vertex, index::{Index, PrimitiveType}};
use glutin::surface::WindowSurface;

pub fn vbo_persistent<T: Vertex>(vbo: &mut VertexBuffer<T>, display: &Display<WindowSurface>, size: usize) {
	if size > vbo.len() {
		*vbo = VertexBuffer::empty_persistent(display, size.next_power_of_two()).unwrap();
	}
}

pub fn ibo_persistent<T: Index>(ibo: &mut IndexBuffer<T>, display: &Display<WindowSurface>, prim_type: PrimitiveType, size: usize) {
	if size > ibo.len() {
		*ibo = IndexBuffer::empty_persistent(display, prim_type, size.next_power_of_two()).unwrap();
	}
}
