// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use glium::{Blend, BlendingFunction, LinearBlendingFactor};

/*
 * Blend::alpha_blending is broken on Wayland, with the window actually being
 * transparent, so need to manually do this.
 *
 * Modified from: https://github.com/PistonDevelopers/conrod/issues/1347
 *
 * I think this might be unnecessary after a change to one of the crates, but if
 * it works, don't fix it.
 */
pub const ALPHA_BLENDING: Blend = Blend {
	color: ALPHA_BLENDING_FUNC,
	alpha: BlendingFunction::Max, // Differs from Blend::alpha_blending, makes sure that the alpha channel is always 1
	constant_value: (0.0, 0.0, 0.0, 0.0),
};

pub const ALPHA_BLENDING_FUNC: BlendingFunction = BlendingFunction::Addition { source: LinearBlendingFactor::SourceAlpha, destination: LinearBlendingFactor::OneMinusSourceAlpha };
pub const ADDITIVE_BLENDING_FUNC: BlendingFunction = BlendingFunction::Addition { source: LinearBlendingFactor::SourceAlpha, destination: LinearBlendingFactor::One };
