// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
mod clock;
mod rolling_average;
#[cfg(feature = "client")] pub mod glium_resize;
#[cfg(feature = "client")] mod glium_writer;
#[cfg(feature = "client")] mod swap_remove;
pub mod maths;
pub mod rng;
#[cfg(feature = "client")] pub mod blending;
mod to_str;
pub mod ctrl_c;
pub mod escape;
pub mod texture;
pub mod command;
mod split;
pub mod max_len;
#[cfg(feature = "client")] pub mod task;
pub mod string_list;
pub mod or;
pub mod component_finder;
pub mod directory_traversal;
pub mod ron;
pub mod comparison;

pub use clock::Clock;
#[cfg(feature = "client")] pub use rolling_average::RollingAverage;
pub use rolling_average::TimedRollingAverage;
#[cfg(feature = "client")] pub use swap_remove::SwapRemoveIterator;
#[cfg(feature = "client")] pub use glium_writer::GliumWriter;
pub use to_str::ToStr;
pub use split::split;

pub const INDENTATION: &str = "   ";
