// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use super::{World, ServerChanges, PlayerId, Pathfinding};

use crate::world::player::Player;

pub struct Input<'a> {
	pub world: &'a World,
	pub changes: &'a ServerChanges,
	pub dt: f32,
	pub player: &'a Player,
	pub player_id: PlayerId,
	pub pathfinding: &'a Pathfinding,
	pub config: &'a Config,
}

pub struct Config {
	pub block_size: f32,
	pub block_size_squared: f32,
}
