// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::net::IpAddr;

use crate::net::utils::hostname::Hostname;

pub struct PublishingStatus {
	pub host: Box<str>,
	pub hostname: Option<Hostname>,
	pub connection: ConnectionStatus,
}

pub enum ConnectionStatus {
	Connecting,
	Connected,
}

pub struct PublicationStatus(pub Vec<PublishingServerStatus>);

pub struct PublishingServerStatus {
	pub addr: IpAddr,
	pub hostname: Option<Hostname>,
	pub game_server_count: usize,
}
