// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use super::*;

#[tokio::test]
async fn property() {
	for i in 0..500 { same_back(Vu30(i)).await; }
	for _ in 0..500 { same_back(Vu30(Vu30::B2_BEGIN + rand::random::<u32>() % (1 << 6))).await; }
	for _ in 0..2000 { same_back(Vu30(Vu30::B3_BEGIN + rand::random::<u32>() % (1 << (6 + 8)))).await; }
	for _ in 0..2000 { same_back(Vu30(Vu30::B4_BEGIN + rand::random::<u32>() % (1 << (6 + 8 * 2)))).await; }

	for i in -10..10 {
		same_back(Vu30((Vu30::B3_BEGIN as i32 + i) as u32)).await;
		same_back(Vu30((Vu30::B4_BEGIN as i32 + i) as u32)).await;
	}

	for i in 0..10 {
		same_back(Vu30(Vu30::MAX.0 - i)).await;
	}
}

async fn same_back(x: Vu30) {
	let mut buf = Vec::new();
	buf.write_vu30(x).await.unwrap();
	let y = ReadVu30::read_vu30(&mut buf.as_slice()).unwrap();
	assert_eq!(x.0, y.0);

	buf.clear();
	buf.write_vu30(x).await.unwrap();
	let y = AsyncReadVu30::read_vu30(&mut buf.as_slice()).await.unwrap();
	assert_eq!(x.0, y.0);
}
