// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::io::Read;

use super::{Reader, Vu30, Error, ReadError, super::{SIZE_LIMIT, vu30::AsyncReadVu30}};

pub struct MockReader<'a>(pub &'a [u8]);

impl Reader for MockReader<'_> {
	async fn read_exact(&mut self, data: &mut [u8]) -> Result<(), Error> {
		self.0.read_exact(data).map_err(|_| Error::Disconnected(None))?;
		Ok(())
	}

	async fn read_vu30(&mut self) -> Result<Vu30, Error> {
		self.0.read_vu30().await.map_err(|()| Error::Disconnected(None))
	}

	async fn read_bytes(&mut self) -> Result<Vec<u8>, (Error, ReadError)> {
		self.0.read_bytes(SIZE_LIMIT).await.map_err(|err| (Error::Disconnected(None), err))
	}

	async fn read_string(&mut self) -> Result<String, Error> {
		self.0.read_string(SIZE_LIMIT).await.map_err(|_| Error::Disconnected(None))
	}
}
