// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::sync::Arc;

use egui::{Id, LayerId, Order, FontId, FontFamily, Context};

use super::scores::{GREY, MARGIN};

use crate::app::gui::style::SCORE_H1_SIZE;

pub fn render(ctx: &Context, time: String) {
	let painter = ctx.layer_painter(LayerId { order: Order::Foreground, id: Id::NULL });
	let galley = painter.layout_no_wrap(time, FontId::new(SCORE_H1_SIZE, FontFamily::Name(Arc::from("scores"))), GREY);

	let lwinsize = ctx.screen_rect().size();

	painter.galley([lwinsize.x - galley.rect.width() - MARGIN, MARGIN].into(), galley, GREY);
}
