// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::sync::Arc;

use egui::{Window, Frame, FontId, FontFamily, RichText, Context};

use super::scores::{GREY, MARGIN};

use crate::app::gui::{style::{SCORE_H1_SIZE, SCORE_H2_SIZE}, layout_job_helper::LayoutJobHelper};
use crate::app::playing::model::client::LevelInfo;

pub fn render(ctx: &Context, info: &LevelInfo) {
	Window::new("level")
		.frame(Frame::none())
		.fixed_pos([MARGIN, MARGIN])
		.min_width(f32::MAX)
		.resizable(false)
		.title_bar(false)
		.show(ctx, |ui| {
			ui.label(RichText::new("Lives").color(GREY).font(FontId::new(SCORE_H1_SIZE, FontFamily::Name(Arc::from("scores")))));
			ui.add_space(8.0);

			let job = LayoutJobHelper::with_font_id(FontId::new(SCORE_H2_SIZE, FontFamily::Name(Arc::from("scores"))))
				.indent(SCORE_H2_SIZE)
				.add(&format!("{} / {}", info.get_lives(), info.get_init_lives()), GREY)
				.build();
			ui.label(job);

			ui.add_space(SCORE_H1_SIZE * 2.0);

			ui.label(RichText::new("Bots").color(GREY).font(FontId::new(SCORE_H1_SIZE, FontFamily::Name(Arc::from("scores")))));
			ui.add_space(8.0);

			let job = LayoutJobHelper::with_font_id(FontId::new(SCORE_H2_SIZE, FontFamily::Name(Arc::from("scores"))))
				.indent(SCORE_H2_SIZE)
				.add(&format!("{} / {}", info.get_must_kill(), info.get_init_must_kill()), GREY)
				.build();
			ui.label(job);
		});
}
