// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use glium::Frame;
use egui::Context;

use crate::app::App;

pub fn render(app: &mut App, frame: &mut Frame, mut f: impl FnMut(&Context)) {
	app.gui.update(&app.window, |ctx| {
		/*
		 * Temporarily sets the animation time to zero so that the ammo status
		 * window appears immediately.
		 *
		 * Also don't want labels to be selectable for any initial events
		 * (haven't observed this but I want to be safe).
		 */
		let mut prev_animation_time = 0.0;
		let mut prev_selectable_labels = false;
		ctx.style_mut(|style| {
			prev_animation_time = style.animation_time;
			prev_selectable_labels = style.interaction.selectable_labels;
			style.animation_time = 0.0;
			style.interaction.selectable_labels = false;
		});

		f(ctx);

		ctx.style_mut(|style| {
			style.animation_time = prev_animation_time;
			style.interaction.selectable_labels = prev_selectable_labels;
		});
	});

	app.gui.render(&app.display, frame);
}

