// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use strum::EnumCount;

use super::PowerupType;

use crate::utils::Clock;

pub struct ParticleClock {
	clocks: [(Clock, u32); PowerupType::COUNT],
}

impl ParticleClock {
	pub fn new() -> ParticleClock {
		ParticleClock {
			clocks: const {
				let mut time = [0.0; PowerupType::COUNT];
				time[PowerupType::Speed as usize] = 1.0 / 60.0;
				time[PowerupType::Reload as usize] = 1.0 / 15.0;
				time[PowerupType::Health as usize] = 1.0 / 12.5;
				time[PowerupType::Damage as usize] = 1.0 / 8.0;
				time[PowerupType::Forcefield as usize] = 1.0 / 60.0;
				time[PowerupType::Teleportation as usize] = 1.0 / 7.5;
				time
			}.map(|time| (Clock::new(time), 0))
		}
	}

	pub fn advance(&mut self, dt: f32) -> bool {
		let mut spawn_particles = false;
		for clock in &mut self.clocks {
			clock.1 = clock.0.advance(dt);
			spawn_particles |= clock.1 > 0;
		}
		spawn_particles
	}

	pub fn get_count(&self, effect: PowerupType) -> u32 {
		self.clocks.get(effect as usize).map(|clock| clock.1).unwrap_or_default()
	}
}
