// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::f32::consts::TAU;

use glam::{Vec2, Vec4};

use super::super::Particle;

use crate::utils::maths::decay::Decay;
use crate::world::powerup::RADIUS;

pub struct Health {
	pos: Vec2,
	size: f32,
	blue: f32,
	dir: Vec2,
	r: f32,
	min_r: f32,
	speed: f32,
	time: f32,
}

impl Health {
	pub fn new(pos: Vec2) -> Health {
		Health {
			pos,
			size: (rand::random::<f32>() + 1.0) * 0.0390625,
			blue: rand::random::<f32>() * 0.125 + 0.375,
			dir: Vec2::from_angle(rand::random::<f32>() * TAU),
			r: rand::random::<f32>() * 0.75 + 0.5,
			min_r: (rand::random::<f32>() * 0.5 + 0.5) * RADIUS,
			speed: rand::random::<f32>() * 0.375 + 0.375,
			time: 0.0,
		}
	}
}

impl Particle for Health {
	fn get_pos(&self) -> Vec2 {
		self.pos + self.r * self.dir
	}

	fn get_size(&self) -> f32 { self.size }
	fn get_colour(&self) -> Vec4 { Vec4::new(0.5, 0.25, self.blue, (self.time * 2.0).min(1.0).min((self.r - self.min_r) * 4.0)) }

	fn update(&mut self, dt: f32) -> bool {
		self.r.decay(self.speed, dt);
		self.time += dt;
		self.r >= self.min_r
	}
}
