// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
pub mod speed;
pub mod reload;
pub mod health;
pub mod damage;
pub mod forcefield;
pub mod teleportation;
pub mod particle_clock;

use glam::Vec2;

use {speed::Speed, reload::Reload, health::Health, damage::Damage, forcefield::Forcefield, teleportation::Teleportation};

use super::AnyParticle;

use crate::world::powerup::PowerupType;

pub fn new(typ: PowerupType, pos: Vec2) -> AnyParticle {
	match typ {
		PowerupType::Speed => Speed::new(pos).into(),
		PowerupType::Reload => Reload::new(pos).into(),
		PowerupType::Health => Health::new(pos).into(),
		PowerupType::Damage => Damage::new(pos).into(),
		PowerupType::Forcefield => Forcefield::new(pos).into(),
		PowerupType::Teleportation => Teleportation::new(pos).into(),
	}
}
