// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use egui::{Ui, Color32, TextEdit};

use super::style::{FontSize, H4_SIZE};

pub struct PortEdit {
	port: Option<u16>,
	port_s: String,
}

impl PortEdit {
	pub fn new(port: u16) -> PortEdit {
		PortEdit {
			port: Some(port),
			port_s: port.to_string(),
		}
	}

	pub fn add(&mut self, ui: &mut Ui) -> Option<u16> {
		let style = ui.style_mut();
		let orig_bg = style.visuals.extreme_bg_color;
		if self.port.is_none() {
			style.visuals.extreme_bg_color = Color32::from_rgb(0x5f, 0x00, 0x00);
		}
		ui.add(TextEdit::singleline(&mut self.port_s).font_size(H4_SIZE));
		ui.style_mut().visuals.extreme_bg_color = orig_bg;

		self.port = self.port_s.parse().ok();
		self.port
	}
}
