// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::{env, path::{Path, PathBuf}};

use super::FsBase;

#[derive(Clone)]
pub struct Filesystem(Box<Path>);

impl Filesystem {
	#[allow(clippy::unused_async)]
	pub async fn try_new() -> Result<Filesystem, String> {
		let mut path = env::current_exe().map_err(|err| format!("cannot get path of executable: {err}"))?;
		path.pop();
		Ok(Filesystem(path.into_boxed_path()))
	}

	pub fn get(&self, _base: FsBase, path: &Path) -> PathBuf {
		self.0.join("data").join(path)
	}

	pub fn server_config_dirs(&self) -> Vec<Box<Path>> {
		vec![self.0.join("configs").into_boxed_path()]
	}
}
