// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::path::{Path, PathBuf};

use super::FsBase;

#[derive(Clone)]
pub struct Filesystem;

/*
 * Need to shut up clippy to prevent warning from code that's perceived to be
 * unnecessary but needed to get shared method signatures between variations of
 * conditional compilation.
 */
impl Filesystem {
	#[allow(clippy::unnecessary_wraps, clippy::unused_async)]
	pub async fn try_new() -> Result<Filesystem, String> { Ok(Filesystem) }

	#[allow(clippy::unused_self)]
	pub fn get(&self, _base: FsBase, path: &Path) -> PathBuf {
		Path::new("data").join(path)
	}

	#[allow(clippy::unused_self)]
	pub fn server_config_dirs(&self) -> Vec<Box<Path>> {
		vec![Box::from(Path::new("configs"))]
	}
}
