#!/bin/sh
# Script I created to automate the process of generating the Flatpak build
set -e
cd $(dirname $0)/..

rm -rf data/config.ron data/textures data/explosions data/sounds dist/build
mkdir -p dist/build

cd assets
cargo run --release
cargo run --release -- icon 256 ../dist/build/icon.png

cd ../dist/flatpak

# Replace this with your GPG key id
GPG_KEY=7773E8D75EBF0093DCB76190B35D9C0B7D499275

flatpak-builder --force-clean --user --install-deps-from=flathub --repo=repo build me.spaceships.spaceships.json --gpg-sign=$GPG_KEY
flatpak build-update-repo --generate-static-deltas --gpg-sign=$GPG_KEY repo
