#!/bin/bash
# Script I created to automate the process of generating release archives
set -e
cd $(dirname $0)/..

ARCH=x86_64
if [ $(uname -m) != $ARCH ]; then
	echo must run on x86_64 >&2
	exit 1
fi

VERSION=$(grep "^version = " Cargo.toml | sed 's/^.*= "//' | sed 's/"$//')

if [ -z $VERSION ]; then
	echo version not found >&2
	exit 1
fi

rm -rf data/config.ron data/textures data/explosions data/sounds

cd assets
cargo run --release
cd ..

cargo build --release -F standalone
cargo build --release --target=x86_64-pc-windows-gnu -F standalone

rm -rf dist/build
mkdir -p dist/build/spaceships

cp -rv configs data LICENSE README.md dist/build/spaceships
cd dist/build

# Linux standalone
cp -v ../../target/release/spaceships spaceships

FILE=spaceships-$VERSION-linux-$ARCH.tar
tar --owner=0 --group=0 -cvf $FILE spaceships
xz -9 $FILE

# Windows
rm spaceships/spaceships
cp ../../target/x86_64-pc-windows-gnu/release/spaceships.exe spaceships
zip -r9 spaceships-$VERSION-windows-$ARCH.zip spaceships

# Source
pushd ../..
git archive --prefix=spaceships/ -9 v$VERSION -o dist/build/spaceships-$VERSION-source.zip
popd

# Documentation
pushd ../../docs
mdbook build
popd
cp -rv ../../docs/book spaceships-docs
zip -r9 spaceships-$VERSION-docs.zip spaceships-docs
