#!/usr/bin/env python3
# Calculates the area of all triangles in the spaceship model
# This results in 0.625
from sympy import sqrt

def dist(a, b):
	return sqrt((a[0] - b[0]) ** 2 + (a[1] - b[1]) ** 2)

def area(a, b, c): # Converts points to side lengths and uses https://en.wikipedia.org/wiki/Area_of_a_triangle#Using_side_lengths_(Heron's_formula)
	l1 = dist(a, b)
	l2 = dist(a, c)
	l3 = dist(b, c)
	s = (l1 + l2 + l3) / 2
	return sqrt(s * (s - l1) * (s - l2) * (s - l3))

# Vertices of one side of the spaceship
a = (-0.5, 0.5)
b = (0.5, 0)
c = (0.25, 0.375)
d = (-0.25, 0)

# Twice the area for all sides
print(2 * (area(a, b, c) + area(a, b, d)))
