# Server console
When starting the server, you have access to a console that allows addition and removal of game servers, without restarting the entire process. Complete documentation for these particular commands isn't provided here but instead available by running `help` in this console. Instead what is documented here is game ids and basic usage of running multiple game servers on the same process.

When using this console, I recommend redirecting stderr to somewhere else to avoid the logs from distracting you as you write your commands.

## Game ids
A Spaceships server can run multiple different game servers on the same UDP port. When a player joins the game, the client includes a game id in the request it makes to the server to play the game. The server then takes this id and checks its "routing table" to find a game server the player can join. Game ids are either entered manually when manually entering the address, or automatically with online or local discovery.

The exact mapping of game ids to game servers is up to the server. Game servers are limited to having only one game id, and game ids are limited to being at most 64 bytes.

One game server can be configured to be the default, if it has game id "default". Here, if the user entered a game id that doesn't match any explicit rule in the routing table, the player will join this default server. When you start a server without specifying a game id, it will be configured to be the default server.

## Private servers
Game ids can be used to have the server accessible over the internet but restrict who can join the game by requiring users enter a password. Here, the game id *is* the password. This works because clients cannot access to this routing table.

**To ensure that a game server is truly private, it must not be globally discoverable!** This is the case in the default settings *but not if you run the server with `-P global`*. One way to prevent this and still have the game publicly joinable is to add `-P none/global` instead. To verify this privacy setting, run the `status` command which prints out information of all running game servers, including the privacy config.

## Examples
Here are some examples. Lines beginning with `$` indicate a shell, while lines beginning with `>` indicate the server console.

### Multiple servers
Here is an example of how to host multiple game servers on the same process.

```
$ ./spaceships server maze:configs/maze.ron
> add cave:configs/cave.ron
> add white_noise:configs/white_noise.ron
> rename white_noise noise
> add configs/empty.ron
```

After running all of this, the game ids `maze`, `cave` and `noise` are mapped to the servers with configs `configs/maze.ron`, `configs/cave.ron` and `configs/white_noise.ron` respectively, and all other game ids are mapped to `configs/empty.ron` by default.

### Hosting a private server
Here is how to run just a single server only accessible through a hard to guess game id.

```
$ ./spaceships server -P none/global I-L0v3_sP4c35h1p5:configs/private.ron
```

Make sure that no colons are present in the password. If not, the game id would end there and the remainder of the string would be the path of a config file that most likely doesn't exist.
