# Command line
To get started, simply run `./spaceships server configs/survival.ron`.[^windows] This starts a game of survival, where each player has five lives and the winner is the last player alive. In this command, `configs/survival.ron` is the path to the game's *configuration*. If you're using Flatpak, the default configuration files are instead located in `/app/configs/` inside the sandbox.

The server program outputs logs to the terminal (in particular, stderr), which include information about players joining and leaving the game. If you want to save these logs and if your server is publicly accessible, I strongly recommend **not** directly writing to a file (`spaceships server ... 2> out.log`). Doing so can expose you to a [certain type of denial-of-service attack](https://en.wikipedia.org/wiki/Denial-of-service_attack#Application-layer_attacks) where an attacker might be able to completely fill up your storage with logs. I created [a tool](https://codeberg.org/rustydev/loglimit) that allows you to save logs in a way that mitigates this attack.

The server also provides a simple [REPL interface which allows more advanced configuration](./6-server-console.md).

## Online server
By default the server can only be joined from the local network. If you want your server to be available online, you need to perform a few more steps.

First you need to configure the Spaceships server to accept connections from the internet, which by default are prohibited. To do this, add `-P global` to the command line arguments which changes the [privacy settings](#privacy).

The next steps after this are to allow incoming connections from the internet to actually reach the server. What you will need to do isn't unique to Spaceships, these steps are necessary if you want to have any server accessible on the internet, whether that is another game server or a website. Knowing this, other guides for hosting servers such as [this guide for Luanti](https://docs.luanti.org/for-server-hosts/setup/) will also work for Spaceships.

## Allowing internet connections
In some cases, you won't need to do anything![^no-steps]

One option is to have the server hosted on your machine or another machine in your home. To do this, you need to set up [port forwarding](https://en.wikipedia.org/wiki/Port_forwarding) on your router (and possibly update any firewall configuration), which is mapping a port on the public IP address seen by the internet to a port on a private IP address of the machine you're hosting the server. Spaceships uses UDP port 4080 by default, so make sure the port on the private IP address also is 4080. The port associated with the public IP address can be anything, but 4080 is recommended (as this port will already be filled in when connecting by manually entering the address).

Another option is to use a [VPS](https://en.wikipedia.org/wiki/Virtual_private_server), which you might need to use if you're unlucky enough to be behind a [CGNAT](https://en.wikipedia.org/wiki/Carrier-grade_NAT).

### Connecting to the server
To test if the server is available online, you need to try connecting to it with the public IP address. If you're using port forwarding, the public IP address can be found by searching "what is my ip" into your preferred search engine and clicking one of the results. If you're using a VPS, you should already know this.

Joining the game over the internet is done by clicking the "Enter Address" button in the playing screen and manually entering this public IP address (as well as the port if the default of 4080 isn't used). If you don't want players to manually enter an address, [keep reading](#publishing-a-game-server).

If you're using port forwarding, the public IP address might be dynamic and so would change over time. This would require users to periodically change the entered IP address, or [dynamic DNS](https://en.wikipedia.org/wiki/Dynamic_DNS) can be used with users instead entering a hostname.

### Using a TLS certificate
If you're running an online server with an associated domain name, if users want to connect to the server by entering the domain name you will need a valid TLS (also called SSL) certificate. To run the server to use this certificate, run `./spaceships ... --cert-path PATH --key-path PATH`, replacing `PATH` with the paths of the certificate and private key in PEM format.

Updating the certificate without restarting the server can be done with the `cert` command in the [server console](./6-server-console.md). See [`spaceships-cert-status`](https://codeberg.org/rustydev/spaceships-cert-status) for a tool that can be used by a script to create reminders before the certificate expires.

Automatic updating of certificates isn't yet supported, though if you really wanted to, you could automatically write the `cert` command into the server's standard input to execute the command.

### Private servers
Once you've created an online server, *anyone* on the internet can connect to it. If you want to limit this to only those with a password, [see these instructions](./6-server-console.md#private-servers).

## Privacy
Spaceships allows restricting which clients can discover and join each game server. These privacy settings are called discoverability and joinability.

Each privacy setting can be set to a *privacy level*, which can be `none`, `loopback`, `local` or `global` in order from most to least restrictive. By default both discoverability and joinability are set to `local`, which blocks connections from outside the local network.

### Privacy levels
Here's an explanation on each of the four privacy levels for whether clients are allowed to discover/join the server:
* `none`: No clients are allowed.
* `loopback`: Only clients on the same host are allowed.
* `local`: Only clients on the local network are allowed.
* `global`: All clients are allowed. Note that this doesn't automatically allow players on the internet to connect to the game, [see the above instructions](#online-server) to do this.

### Setting the config
To set the default privacy config for game servers, add `--privacy` or `-P` with the given privacy config. This is either a single privacy level (to configure both to the same level) or multiple in the form of discoverability/joinability. Here are two examples:
* `-P global` disables all restrictions for players joining and discovering the server.
* `-P none/local` prevents all clients from discovering servers and limits clients on the local network to joining a server.

Note that the joinability cannot be more restrictive than the discoverability. This prevents players from seeing a game when browsing online or local servers but not being able to join it.

# Publishing a game server
If you want your game server to be available online and included on the public list of online servers, you need to *publish* it to a *publication* server. This is done by adding `--publish ADDRESS` to the command line arguments, replacing "ADDRESS" with `game.spaceships.me` (the default public server list) or the address of another publication server. To change the port of this publication server, add `--publish-port PORT` to the command line arguments.

If you're using a TLS certificate, it is highly recommended to also add `--server-name NAME` to the command line arguments so that players connect with the given hostname and so can obtain a secure connection.

When publishing, all game servers that are *discoverable* by the publication server are published, meaning having global discovery (or less if the discovery server is on the local network). If servers get added or removed using the [server console](./6-server-console.md), this information gets automatically published to the publication server.

If the connection with the publication server is ever lost, the publishing server periodically attempts to reconnect to it.

# Hosting a publication server
If you want to host a server that accepts these publications from other servers, you can do this by simply adding `--accept-publications` to the command line arguments.

[^windows]: On Windows, you would run `./spaceships.exe server ...`.
[^no-steps]: This can happen if you're on a network that doesn't have any NAT or firewall in the way.
