# How to play
There are two ways of playing Spaceships: [singleplayer](./1-1-singleplayer.md) and [multiplayer](./1-2-multiplayer.md).

Multiplayer has existed since the game's creation while a functional singleplayer has only very recently been implemented, being new to v1.5.0. This page will discuss gameplay that is common to both singleplayer and multiplayer.

## Playing the game
Gameplay in Spaceships involves the player controlling a spaceship that they move around and kill other spaceships by firing bullets at them to diminish their health and eventually destroy them.

### Controls
To move around, use WASD or the arrow keys. To change the direction you're looking in and where bullets will be fired from, move the mouse. Bullets are shot by pressing the left mouse button or spacebar. You can hold down these buttons to easily fire multiple bullets at a time. These controls can be changed by pressing the "Settings" button while in the title screen.

You can zoom the camera in and out by scrolling (or by pressing 'J' and 'K'), and you can reset to the default zoom by pressing the middle mouse button.

If you're playing a game that has flags and you have captured one, you can drop it by pressing 'Q'.

### Health
Your health is displayed in the health bar at the bottom of your screen, with the number of bullets also displayed above that. The health bars of other players are displayed right above them. After getting shot, players slowly regenerate their health.

### Ammo
You have a finite amount of bullets (unless the server is configured to provide you infinite), which are reset when you die. Periodically during the game, ammo crates are spawned which supply the player collecting them with a random amount of bullets.

### Powerups
Additionally, powerups are periodically spawned which give the player collecting them a temporary effect. These effects either last for 30 seconds or happen immediately (teleportation) and are listed as follows:
1. **Speed.** This is the green powerup which increases your movement speed.
2. **Reload.** This is the yellow powerup which increases your reload speed, making you shoot faster.
3. **Health.** This is the pink powerup which increases your health and makes you regenerate health faster. The increase of health that this powerup provides can increase your health above the usual limit and make your health bar blue.
4. **Damage.** This is the red powerup which increases the damage of your bullets.
5. **Forcefield.** This is the blue powerup which provides a forcefield that deflects bullets fired by other players.
6. **Teleportation.** This is the purple powerup which teleports you to a random place on the map. Unlike the others, this can be disadvantageous depending where you teleport...

Here are these six powerups:

![Powerups](images/powerups.webp)

## Exiting a game
To exit the game, press escape.

## Player customisation
The name and colour of the player can be changed by [going into the settings](./2-settings.md).
