# Multiplayer
## Joining a game
To play a multiplayer game, first click the "Play" button on the title screen. The next step depends on if the server is hosted on the internet or on the local network.

If the game server is available online, click "Online" and then "Search" to view a list of public online servers. Then click "Play" on the particular server you want to join.

If the game server is hosted on the local network, click "Local" and then click "Search LAN" and if everything works well, the game server will pop up and you can then click "Play".

Sometimes you might need to manually enter the address. This can be if the server is hosted on the local network and the above instructions don't work for some reason (maybe a host or network firewall), or if the server's online but not publicly visible. In that case, click "Enter Address" and enter the IP address or domain name in the "Host" section, and then click "Play". The default settings for "Port" and "Game ID" don't need to be changed unless the server administrator mentions setting them to a particular value.

## Teams
Some Spaceships servers can have teams enabled. When you join the game, you will be assigned to a specific team. To change teams, first list the available teams by running the command ([keep reading](#commands) for information about commands) `teams`. This should return a list of teams on the server. Then run `team NAME` where `NAME` is the name of the team you want to change to.

When in a team, your bullets cannot hit other members of your team (unless the server has friendly fire enabled).

## Winning the game
The way the game is actually won, if there is a way, is highly customisable. On the top-left corner of the screen is a list of scores that the server keeps track of. These scores can increase or decrease when certain events happen, such as when a player gets a kill or kills someone else.

Here is a list of a few examples of win conditions that are possible:
* First to N kills.
* Most kills within a certain amount of time.
* Last player remaining where players are eliminated if they lose too many lives.

## Chat
Spaceships has two types of in-game chat that you can use to talk to other players. The first type is team chat which allows you to talk to your team members. To open team chat, press 'T' (you can bind this to something different), start typing and press enter to send your message. Only other players on your team will receive your message, unless teams are disabled in which all players will receive the message.

The second type of chat is global chat which lets you talk to all players. Opening global chat is done by pressing 'G'.

## Commands
Spaceships also supports sending commands to the server using the chat window. To send a command, first press '/' (again, can be rebinded), type your command and then press enter to send it. Run the `help` command to get an exact list of commands the server supports.

Note that opening chat and typing a message beginning with '/' **won't execute a command** and instead send a regular message.

### Underpowering
If you're an experienced player playing with a friend who is new to the game, you can choose to make yourself weaker to make the game fairer. This is called *underpowering* and is done by executing commands.

For an example, to decrease your speed to 75% of what it usually is, run `underpower speed 75%`. Note that you can use 0.75 instead of 75%, and the alias `up` can be used. Another example is to completely disable regeneration, you can run `up regen 0`.

The general syntax for this specific subcommand is `underpower/up EFFECT VALUE`, where `EFFECT` is `speed`, `reload`, `regen` (or `regeneration`) and `damage`, and value is a number or a percentage.

## Security
If you're playing this game online, you might be concerned about whether encryption is used, especially when it comes to chat messages which might be sensitive. Spaceships uses QUIC, a transport-layer protocol over UDP that always uses encryption. However, that doesn't mean that all communications are secure.

First note that the security I'm referring to here is about whether a malicious device on the path between the client and the server can eavesdrop communications. **All chat messages are logged for the server owner to read, so if you don't trust the server owner, don't send any sensitive chat messages.**

While playing the game, the connection's security is displayed in the bottom-left corner when the chat window is open. This information is one of the three security levels, "Secure", "Local" and "Insecure".

### Secure
If a connection is secure, as indicated by the green text saying "Secure connection", it is very unlikely that communication is being eavesdropped.

This level of security is reached when the server is hosted on the same device, or a trusted TLS certificate is used. This level of security is the same as HTTPS on the web.

### Local
If a connection is local, as indicated by the blue text saying "Local connection", it means that the connection isn't secure, *but can only be eavesdropped by an attacker on the local network*. If you're connecting to a server on the local network and you trust that network, communications are secure.

### Insecure
If a connection is insecure, as indicated by the red text saying "INSECURE connection!", it means that the connection isn't secure and can be eavesdropped by an attacker on the internet that controls a node on the path. This attacker can be an ISP or a government agency.

For most users, it is unlikely that there actually is an attacker listening into communications, but it is still possible. If you live in an authoritarian regime such as Russia, Saudi Arabia, Myanmar, the United States, Israel, China, Iran or the United Kingdom, you shouldn't send any chat messages that the government would disapprove of if using an insecure connection. It's better to be safe than sorry.

### Note on eavesdropping
I mentioned earlier that encryption is always enabled in Spaceships. That is true but it is still possible to eavesdrop by performing a [man-in-the-middle attack](https://en.wikipedia.org/wiki/Man-in-the-middle_attack) in which an attacker impersonates the server and can decrypt communications.

This encryption is still better than nothing as it fully prevents against passive eavesdropping attacks, where the attacker can only listen in but can't modify the messages.

## Spectator mode
If you want to watch a game play out but not be an active player, you can join as a spectator. To do this, click the checkbox before starting the game or execute the `spectate` command while playing the game.

While in spectator mode, you can move the camera around using WASD or the arrow keys and you can also drag the camera using the mouse. You can also press 'F' to toggle between freely moving around and following another player in the world.

Some game modes can eliminate the player before the game ends, in which those players will be forcefully put into spectator mode.
