// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 tex_coords_io;
in vec2 cloud_fb_coords_io;
in float alpha_io;
flat in uint layer_io;

out vec4 colour;

uniform sampler2DArray u_texture;
uniform sampler2D u_cloud_fb;
uniform float u_intensity;
uniform float u_colour_brightness;
uniform float u_colour_offset;

void main() {
	float intensity = min(texture(u_texture, vec3(tex_coords_io, layer_io)).r * u_intensity, 1);
	vec3 clouds = texture(u_cloud_fb, cloud_fb_coords_io).rgb * u_colour_brightness + u_colour_offset;

	// Quadratic Bézier curve with points [vec3(0), clouds, max(clouds, vec3(1))]
	vec3 bezier = intensity * (2 * clouds * (1 - intensity) + intensity * max(clouds, vec3(1)));
	colour = vec4(bezier, alpha_io);
}
