// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec3 tex_coords_io;
in vec3 colour_io;
in float brightness_io;
in float alpha_io;

out vec4 colour;

uniform sampler2DArray u_texture;

void main() {
	vec2 tex_colour = texture(u_texture, tex_coords_io).rg;
	colour = vec4(mix(vec3(tex_colour.r), colour_io, tex_colour.g) * brightness_io, alpha_io);
}
