// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;
in float v_grad;

in vec2 i_pos;
in vec2 i_rotation;
in float i_fade;
in float i_gradient_pulse;
in float i_lightning_pulse;

out float alpha_io;
out float grad_io;
out float pulse_io;

uniform mat4 u_matrix;
uniform float u_radius;
uniform float u_pulse_per_vertex;

void main() {
	vec2 rotated_pos = vec2(v_pos.x * i_rotation.x - v_pos.y * i_rotation.y, v_pos.x * i_rotation.y + v_pos.y * i_rotation.x);
	gl_Position = u_matrix * vec4(rotated_pos * u_radius * i_fade + i_pos, 0, 1);
	alpha_io = i_fade;
	grad_io = float(gl_VertexID % 2);
	pulse_io = i_lightning_pulse - float(gl_VertexID / 2) * u_pulse_per_vertex;
}
