// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;

in vec2 i_pos;
in vec2 i_rotation;
in float i_fade;
in float i_gradient_pulse;
in float i_lightning_pulse;

out vec2 pos_io;
out float alpha_io;
out float pulse_io;

uniform mat4 u_matrix;
uniform float u_radius;

void main() {
	gl_Position = u_matrix * vec4(i_pos + v_pos * u_radius * i_fade, 0, 1);
	pos_io = v_pos;
	alpha_io = i_fade;
	pulse_io = i_gradient_pulse;
}
