// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 pos_io;
in float alpha_io;
in float pulse_io;

out vec4 colour;

void main() {
	float t = length(pos_io);
	float use_fragment = float(t <= 1);
	float alpha = (256 / 27) * t * t * t * (1 - t);
	float theta = pulse_io - t * 16;
	float pulse = 0.75 * pow((sin(theta) + 1) / 2, 8) + 0.25 * pow((sin(theta * 4) + 1) / 2, 8);
	alpha *= pulse * 0.5 + 0.5;
	alpha *= alpha_io * use_fragment;
	colour = vec4(0, 0.375, 1, alpha);
}
