// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;

in vec2 i_pos;
in vec2 i_radii;
in uint i_layer;
in float i_int;

out vec2 tex_coords_io;
flat out uint layer_io;
out float int_io;

void main() {
	gl_Position = vec4(v_pos, 0, 1);
	tex_coords_io = i_pos + i_radii * v_pos;
	tex_coords_io.y = -tex_coords_io.y;
	layer_io = i_layer;
	int_io = i_int;
}
