// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;
in vec2 v_tex_coords;

in vec2 i_pos;
in float i_t;

out vec2 tex_coords_io;
out float saturation_io;
out float brightness_io;

uniform mat4 u_matrix;

void main() {
	float scale = i_t * (i_t - 1);
	scale = 1 + scale * scale;
	gl_Position = u_matrix * vec4(i_pos + v_pos * scale, 0, 1);
	tex_coords_io = v_tex_coords;
	saturation_io = i_t * (6 + i_t * (-9 + i_t * 4));
	brightness_io = (1 - i_t) * (saturation_io - i_t);
}
