// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 tex_coords_io;
in float saturation_io;
in float brightness_io;

out vec4 colour;

uniform sampler2D u_texture;

void main() {
	vec3 colourful = texture(u_texture, tex_coords_io).rgb;
	vec3 grey = vec3((colourful.r + colourful.g + colourful.b) / 3);
	colour = vec4(mix(grey, mix(colourful, colourful * (2 - colourful), brightness_io), saturation_io), 1);
}
