// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;
in vec2 v_tex_coords;

in vec2 i_pos;
in vec3 i_tint;

out vec2 tex_coords_io;
out vec3 tint_io;

uniform mat4 u_matrix;

void main() {
	gl_Position = u_matrix * vec4(v_pos + i_pos, 0, 1);
	tex_coords_io = v_tex_coords;
	tint_io = i_tint;
}
