// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 world_pos;
in vec2 ndc_pos;
in vec2 use_ndc;

uniform mat4 u_matrix;
uniform vec2 u_world_size;

void main() {
	gl_Position = u_matrix * vec4(world_pos * u_world_size, 0, 1);
	gl_Position.xy = mix(gl_Position.xy, ndc_pos, use_ndc);
}
