// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 grad_pos_io;
in float grad_type_io;

out vec4 colour;

uniform float u_alpha;

void main() {
	float type0 = max(1 - length(grad_pos_io), 0);
	float type1 = 1 - grad_pos_io.x * grad_pos_io.y;
	float alpha = mix(type0, type1, grad_type_io) * u_alpha;
	colour = vec4(vec3(1), alpha);
}
