// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use png::ColorType;

use super::inkscape;

use crate::utils;

const WIDTH: usize = 384;
const HEIGHT: usize = 427;

const INPUT: &str = "data/flag.svg";
const OUTPUT: &str = "../data/textures/flag.png";

pub fn generate() {
	if utils::newer(INPUT, OUTPUT) {
		inkscape::gen_grey_layers("flag", INPUT, &["base", "colour", "alpha"], WIDTH, HEIGHT).save(OUTPUT, ColorType::Rgb);
	}
}
