// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use png::ColorType;

use super::image::Image;
use super::inkscape;

use crate::utils;

pub fn generate() {
	const INPUT: &str = "data/bullet.svg";
	const INTERMEDIATE: &str = "/tmp/bullet.png";
	const OUTPUT: &str = "../data/textures/bullet.png";
	const BULLET_IMAGE_TYPE: ColorType = ColorType::Rgba;

	const SIZE: usize = 64;

	if !utils::newer(INPUT, OUTPUT) { return; }

	inkscape::gen_image(INPUT, INTERMEDIATE, SIZE, SIZE, BULLET_IMAGE_TYPE);
	Image::load(INTERMEDIATE, BULLET_IMAGE_TYPE).flip_vertical(BULLET_IMAGE_TYPE).save(OUTPUT, BULLET_IMAGE_TYPE);
}
