// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use png::ColorType;
use static_assertions::const_assert;

use super::inkscape;
use super::image::Image;

use crate::utils;

pub fn generate() {
	const INPUT: &str = "data/block.svg";
	const INTERMEDIATE: &str = "/tmp/block.png";
	const OUTPUT: &str = "../data/textures/block.png";
	const BLOCK_IMAGE_TYPE: ColorType = ColorType::Rgba;

	const SIZE: usize = 256;

	if !utils::newer(INPUT, OUTPUT) { return; }

	inkscape::gen_image(INPUT, INTERMEDIATE, SIZE, SIZE, BLOCK_IMAGE_TYPE);

	let mut image = Image::load(INTERMEDIATE, BLOCK_IMAGE_TYPE);

	assert!(image.width == SIZE && image.height == SIZE);
	const_assert!(SIZE.is_multiple_of(4)); // Might change this in the future

	for y in 0..SIZE / 2 {
		let mut src_i = y * SIZE + y;
		for x in y..SIZE / 2 {
			let mut set = |x: usize, y: usize| {
				const CHANNEL_COUNT: usize = 4;
				assert!(BLOCK_IMAGE_TYPE == ColorType::Rgba); // If I change this in the future, the following function will break

				let dst_i = x + y * image.width;
				for i in 0..CHANNEL_COUNT {
					image.pixels[dst_i * CHANNEL_COUNT + i] = image.pixels[src_i * CHANNEL_COUNT + i];
				}
			};

			//set(x, y);
			set(y, x);
			set(SIZE - 1 - x, y);
			set(SIZE - 1 - y, x);
			set(x, SIZE - 1 - y);
			set(y, SIZE - 1 - x);
			set(SIZE - 1 - x, SIZE - 1 - y);
			set(SIZE - 1 - y, SIZE - 1 - x);

			src_i += 1;
		}
	}

	image.save(OUTPUT, BLOCK_IMAGE_TYPE);
}
