// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use png::ColorType;

use super::{inkscape, image::Image};

use crate::utils;

pub fn generate() {
	const INPUT: &str = "data/ammo_crate.svg";
	const INTERMEDIATE: &str = "/tmp/ammo_crate.png";
	const OUTPUT: &str = "../data/textures/ammo_crate.png";
	const AMMO_CRATE_IMAGE_TYPE: ColorType = ColorType::Rgba;

	const SIZE: usize = 171;

	if !utils::newer(INPUT, OUTPUT) { return; }

	inkscape::gen_image(INPUT, INTERMEDIATE, SIZE, SIZE, AMMO_CRATE_IMAGE_TYPE);

	let mut image = Image::load(INTERMEDIATE, AMMO_CRATE_IMAGE_TYPE);

	assert!(image.width == SIZE && image.height == SIZE);

	for y in 0..SIZE / 2 {
		let mut src_i = y * SIZE;
		for x in 0..SIZE / 2 {
			let mut set = |x: usize, y: usize| {
				const CHANNEL_COUNT: usize = 4;
				assert!(AMMO_CRATE_IMAGE_TYPE == ColorType::Rgba); // If I change this in the future, the following function will break

				let dst_i = x + y * image.width;
				for i in 0..CHANNEL_COUNT {
					image.pixels[dst_i * CHANNEL_COUNT + i] = image.pixels[src_i * CHANNEL_COUNT + i];
				}
			};

			//set(x, y);
			set(SIZE - 1 - x, y);
			set(x, SIZE - 1 - y);
			set(SIZE - 1 - x, SIZE - 1 - y);

			src_i += 1;
		}
	}

	image.save(OUTPUT, AMMO_CRATE_IMAGE_TYPE);
}
