// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#[derive(Clone, Copy)]
pub struct Task {
	name: &'static str,
	func: fn(),
}

impl Task {
	pub fn new(name: &'static str, func: fn()) -> Task {
		Task { name, func }
	}

	pub fn run(self, index: usize, total: &str) {
		let width = total.len();
		println!("[{:width$}/{total}] {}...", index + 1, self.name);
		(self.func)();
	}
}
