// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::{array, f32::consts::TAU};

use super::{DELTA_TIME, sampler::{BrownianNoise, WhiteNoise}, resampler::{Resampler, SmoothstepResampler}};

const AMPLITUDE: f32 = 0.125;
const TIME: f32 = 2.5;

pub fn generate() {
	let mut noises: [_; 8] = array::from_fn(|i| SmoothstepResampler::new(BrownianNoise::new(1.0 / (i + 1) as f32, 419023490 + i as u64)));
	let mut noise2 = SmoothstepResampler::new(WhiteNoise::new(6142658901));
	let mut noise3 = SmoothstepResampler::new(WhiteNoise::new(6142658902));
	let mut noise4 = SmoothstepResampler::new(WhiteNoise::new(6142658903));

	super::generate("thrust", TIME, AMPLITUDE, |t| {
		let wave = (t * 450.0 * TAU).sin() * 0.25 + 0.75 + noise2.next(DELTA_TIME * 2000.0).powi(9) * 0.1875 + noise3.next(DELTA_TIME * 4000.0).powi(27) * 0.3125 + noise4.next(DELTA_TIME * 8000.0).powi(15) * 0.0703125;
		let mut amplitude = 0.0;
		for (i, noise) in noises.iter_mut().enumerate() {
			let s = (i as f32 + 1.0).powi(2);
			amplitude += noise.next(DELTA_TIME * 1000.0 * s) / s;
		}
		wave * amplitude
	}).loopable();
}
