// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::array;

use super::chirp::ExponentialChirp;

const AMPLITUDE: f32 = 0.5;
const TIME: f32 = 0.75;

fn note_envelope(t: f32) -> f32 {
	(1.0 - (t * 2.0).powi(2)).max(0.0) * (t * 24.0).min(1.0)
}

pub fn generate() {
	let freq_chirps: [ExponentialChirp; 8] = array::from_fn(|i| ExponentialChirp::new(600.0 * (i + 1) as f32, 1000.0 * (i + 1) as f32, TIME));
	let amplitude_chirp = ExponentialChirp::new(25.0, 75.0, TIME);

	let freq_chirp2 = ExponentialChirp::new(3000.0, 1000.0, TIME);

	super::generate("regen", TIME, AMPLITUDE, |t| {
		let mut wave = 0.0;
		for (i, chirp) in freq_chirps.iter().enumerate() {
			wave += chirp.get(t, 0.75) / (i + 1).pow(3) as f32 * (1.0 - t / TIME).powf(1.0 + i as f32 * 0.75);
		}

		wave *= amplitude_chirp.get(t, 0.875);

		wave += freq_chirp2.get(t, 1.5) * note_envelope((t * (20.0 + 10.0 * t)) % 1.0) * (1.0 - t / TIME).powi(2) * (t / TIME * 16.0).min(1.0);

		let t = t / TIME;
		let amplitude = 4.0 * t * (1.0 - t);
		wave * amplitude
	});
}
